/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.contracts.model.ContractType;
import itx.erp.contracts.service.ContractService;
import itx.erp.contracts.validator.ContractTypeValidator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;

public class ContractTypeController
extends BaseController {
    protected ContractService contractService;

    public ContractService getContractService() {
        return this.contractService;
    }

    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest r) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<ContractType> cts = this.contractService.readAllContractTypes();
        HashMap<String, List<ContractType>> m = new HashMap<String, List<ContractType>>();
        m.put("contractTypes", cts);
        r.renderJson(m);
    }

    public void viewAction(WebRequest r) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer id = r.getParamInt("id");
        ContractType ct = this.contractService.readContractType(id);
        HashMap<String, ContractType> m = new HashMap<String, ContractType>();
        m.put("contractType", ct);
        r.renderJson(m);
    }

    public void saveAction(WebRequest r) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer id = r.getParamInt("contractTypeId");
        ContractType ct = id != null ? this.contractService.readContractType(id) : new ContractType();
        ct.setName(r.getParameterTrim("name"));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ContractTypeValidator v = new ContractTypeValidator();
        if (v.validate(ct)) {
            id = this.contractService.saveContractType(ct, r.getUserId());
            result.put("success", true);
            result.put("contractType", ct);
        } else {
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        r.renderJson(result);
    }

    public void deleteAction(WebRequest r) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer contractTypeId = r.getParamInt("contractTypeId");
        this.contractService.deleteContractType(contractTypeId, r.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        r.renderJson(result);
    }

    public void updateSortAction(WebRequest r) throws SQLException, StreamWriteException, DatabindException, IOException {
        String strIds = r.getParameter("ids");
        String[] arrids = strIds.split(",");
        this.contractService.updateSortContractType(arrids);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        r.renderJson(result);
    }

    public void listTypesAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        List<ContractType> ctypes = this.contractService.readAllContractTypes();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("contractTypes", ctypes);
        req.renderJson(result);
    }
}

